<?php

namespace Drupal\search_api_algolia;

use Drupal\search_api\Item\FieldInterface;

/**
 * Search query helper.
 */
class SearchQueryHelper {

  /**
   * Format a value for filtering on a field of a specific type.
   *
   * @param bool|float|int|string|null $value
   *   The value to be formatted.
   * @param \Drupal\search_api\Item\FieldInterface $field
   *   The Search API field the value should be formatted for.
   *
   * @return float|int|string
   *   The formatted value.
   */
  public function formatFilterValue($value, FieldInterface $field) {
    switch ($field->getType()) {
      case 'boolean':
        return $value ? 'true' : 'false';

      case 'string':
      case 'text':
        return "'" . addslashes($value) . "'";

      default:
        return $value;
    }
  }

}
