<?php

namespace Drupal\search_api_content_type;

use Drupal\Core\Field\FieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

/**
 * Computed field item list for the content type machine name.
 */
class ContentTypeMachineNameFieldItemList extends FieldItemList {

  use ComputedItemListTrait;

  /**
   * {@inheritdoc}
   */
  protected function computeValue() {
    $entity = $this->getEntity();
    // The bundle key is the machine name of the content type.
    $this->list[0] = $this->createItem(0, $entity->bundle());
  }

}
