<?php

namespace Drupal\search_api_decoupled\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a search api decoupled filter annotation object.
 *
 * Plugin Namespace: Plugin\search_api_decoupled\filter.
 *
 * @Annotation
 */
class SearchApiDecoupledFilter extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the search api decoupled filter.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the search api decoupled filter.
   *
   * This property is optional and it does not need to be declared.
   *
   * This will be shown when adding or configuring this search api decoupled
   * filter.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description = '';

}
