<?php

namespace Drupal\search_api_decoupled\Form;

/**
 * Provides an add form for search api decoupled filters.
 *
 * @internal
 */
class SearchApiDecoupledFilterAddForm extends SearchApiDecoupledFilterFormBase {

  /**
   * {@inheritdoc}
   */
  protected function prepareFilter($filter) {
    $plugin = $this->searchFilterManager->createInstance('standard', ['field' => $filter]);
    foreach ($this->searchApiEndpoint->getIndexFieldsDefinitions() as $field => $definition) {
      if ($field === $filter) {
        $plugin = $this->searchFilterManager->createInstance($definition->getType(), [
          'field' => $filter,
          'label' => $definition->getLabel(),
        ]);
        break;
      }
    }
    // Set the initial weight so this element comes last.
    $plugin->setWeight(count($this->searchApiEndpoint->getFilters()));
    return $plugin;
  }

}
