<?php

namespace Drupal\search_api_decoupled\Plugin\search_api_decoupled\filter;

use Drupal\Core\Datetime\DrupalDateTime;

/**
 * Provides a date filter.
 *
 * @SearchApiDecoupledFilter(
 *   id = "date",
 *   label = @Translation("Date"),
 *   description = @Translation("Filter for date fields.")
 * )
 */
class DateFilter extends SearchApiDecoupledFilterBase {

  /**
   * {@inheritDoc}
   */
  public function transformUserInput($value) {
    if (is_array($value)) {
      foreach ($value as $key => $date) {
        if (!is_numeric($date)) {
          $date_object = new DrupalDateTime($date);
          $errors = $date_object->getErrors();
          if (empty($errors)) {
            $value[$key] = $date_object->getTimestamp();
          }
        }
      }
    }
    elseif (!is_numeric($value)) {
      $date_object = new DrupalDateTime($value);
      $errors = $date_object->getErrors();
      if (empty($errors)) {
        $value = $date_object->getTimestamp();
      }
    }
    return $value;
  }

}
