<?php

namespace Drupal\search_api_decoupled;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\DependentPluginInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Defines an interface for search api decoupled filter plugins.
 */
interface SearchApiDecoupledFilterInterface extends PluginInspectionInterface, ConfigurableInterface, DependentPluginInterface {

  /**
   * Returns a render array summarizing the configuration of the ui element.
   *
   * @return array
   *   A render array.
   */
  public function getSummary();

  /**
   * Returns the search api decoupled filter label.
   *
   * @return string
   *   The search api decoupled filter label.
   */
  public function label();

  /**
   * Returns the unique ID representing the search api decoupled filter.
   *
   * @return string
   *   The search api decoupled filter ID.
   */
  public function getUuid();

  /**
   * Gets the search api decoupled filter field.
   *
   * @return string
   *   The field name.
   */
  public function getField();

  /**
   * Sets the search api decoupled filter field.
   *
   * @param string $field_name
   *   The field name.
   *
   * @return $this
   */
  public function setField(string $field_name);

  /**
   * Gets the search api decoupled filter operator.
   *
   * @return string
   *   The filter operator.
   */
  public function getOperator();

  /**
   * Sets the search api decoupled filter operator.
   *
   * @param string $operator
   *   The operator.
   *
   * @return $this
   */
  public function setOperator(string $operator);

  /**
   * Gets the search api decoupled filter value.
   *
   * @return mixed
   *   The filter value.
   */
  public function getValue();

  /**
   * Sets the search api decoupled filter value.
   *
   * @param mixed $value
   *   The filter value.
   *
   * @return $this
   */
  public function setValue($value);

  /**
   * Validates user input.
   *
   * @param mixed $value
   *   Input value.
   * @param string $operator
   *   Operator for value (optional).
   *
   * @return bool
   *   TRUE in case input is valid, FALSE otherwise.
   */
  public function validateUserInput($value, $operator = 'equal');

  /**
   * Transform user input.
   *
   * @param mixed $value
   *   Input value.
   *
   * @return mixed
   *   Transformed user input.
   */
  public function transformUserInput($value);

}
