/**
 * @file
 * Contains javascript functionality for the search api decoupled admin ui.
 */

(function (window, Drupal, once) {

  'use strict';

  Drupal.searchApiDecoupled = Drupal.searchApiDecoupled || {};

  Drupal.searchApiDecoupled.moveFilter = function (evt) {
    const element = evt.item;
    element.closest('.search-api-filters').querySelectorAll('.search-filter-order-weight').forEach(function (el, index) {
      el.value = index;
    });
  }

  Drupal.behaviors.searchApiDecoupledAdmin = {
    attach: function (context, settings) {
      const filters = once('search-api-decoupled-admin-processed', '.search-api-filters', context);
      filters.forEach(function (element) {
        new Sortable(element, {
          animation: 150,
          draggable: '.search-api-filter',
          onEnd: function (evt) {
            Drupal.searchApiDecoupled.moveFilter(evt);
          }
        });
      });
    }
  }

})(window, Drupal, once);
