<?php

namespace Drupal\search_api_decoupled\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\search_api_decoupled\SearchApiEndpointInterface;

/**
 * Form for deleting a search filter.
 *
 * @internal
 */
class SearchApiDecoupledFilterDeleteForm extends ConfirmFormBase {

  /**
   * The search endpoint.
   *
   * @var \Drupal\search_api_decoupled\SearchApiEndpointInterface
   */
  protected $searchApiEndpoint;

  /**
   * The search ui element to be deleted.
   *
   * @var \Drupal\search_api_decoupled\SearchApiDecoupledFilterInterface
   */
  protected $filter;

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete the "@filter" filter from the %label endpoint?',
      [
        '%label' => $this->searchApiEndpoint->label(),
        '@filter' => $this->filter->getLabel(),
      ]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return $this->searchApiEndpoint->toUrl('edit-form');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'search_filter_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, ?SearchApiEndpointInterface $search_api_endpoint = NULL, $filter = NULL) {
    $this->searchApiEndpoint = $search_api_endpoint;
    $this->filter = $this->searchApiEndpoint->getFilter($filter);

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->searchApiEndpoint->deleteFilter($this->filter);
    $this->messenger()->addStatus($this->t('The search filter %name has been deleted.', ['%name' => $this->filter->getLabel()]));
    $form_state->setRedirectUrl($this->searchApiEndpoint->toUrl('edit-form'));
  }

}
