<?php

namespace Drupal\search_api_decoupled\Plugin\search_api_decoupled\filter;

/**
 * Base class for numeric filters.
 */
class NumericFilter extends SearchApiDecoupledFilterBase {

  /**
   * {@inheritDoc}
   */
  public function validateUserInput($value, $operator = 'equal') {
    if (is_array($value)) {
      foreach ($value as $item) {
        if (!is_numeric($item)) {
          return FALSE;
        }
      }
    }
    elseif (!is_numeric($value)) {
      return FALSE;
    }
    return parent::validateUserInput($value, $operator);
  }

}
