<?php

namespace Drupal\search_api_decoupled;

use Drupal\Component\Plugin\FallbackPluginManagerInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages search api decoupled filter plugins.
 *
 * @see hook_search_api_decoupled_filter_info_alter()
 * @see plugin_api
 */
class SearchApiDecoupledFilterPluginManager extends DefaultPluginManager implements FallbackPluginManagerInterface {

  /**
   * Constructs a new SearchUiElementManager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/search_api_decoupled/filter', $namespaces, $module_handler, 'Drupal\search_api_decoupled\SearchApiDecoupledFilterInterface', 'Drupal\search_api_decoupled\Annotation\SearchApiDecoupledFilter');

    $this->alterInfo('search_api_decoupled_filter_info');
    $this->setCacheBackend($cache_backend, 'search_api_decoupled_filter_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function getFallbackPluginId($plugin_id, array $configuration = []) {
    return 'standard';
  }

}
