<?php

namespace Drupal\search_api_hal\Access;

use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\search_api_solr\Access\LocalActionAccessCheck as OriginalLocalActionAccessCheck;
use Drupal\search_api\ServerInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Decorator for search_api_solr.local_action_access_check.
 */
class LocalActionAccessCheckDecorator implements AccessInterface {

  /**
   * The decorated (inner) service.
   *
   * @var \Drupal\search_api_solr\Access\LocalActionAccessCheck
   */
  protected $inner;

  /**
   * The current user (kept if original needs it).
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $currentUser;

  public function __construct(OriginalLocalActionAccessCheck $inner, AccountInterface $current_user) {
    $this->inner = $inner;
    $this->currentUser = $current_user;
  }

  /**
   * Proxy to the inner service with custom logic.
   *
   * Signature mirrors the original access method used by access_check services.
   */
  public function access(AccountInterface $account, ?ServerInterface $search_api_server = NULL) {
    $result = $this->inner->access($account, $search_api_server);
    if($result->isAllowed()) {
      if($search_api_server->getBackend()->getPluginId() == 'search_api_hal') {
        $result = AccessResult::forbidden();
      }
    }
    return $result;
  }
}
