<?php

namespace Drupal\search_api_hal;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Cache\CacheBackendInterface;

/**
 * Class Helper.
 */
class Helper
{

  /**
   * Drupal\Core\Entity\EntityTypeManagerInterface definition.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The cache backend.
   *
   * @var \Drupal\Core\Cache\CacheBackendInterface
   */
  protected $cache;

  /**
   * Constructs a new Helper object.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager, CacheBackendInterface $cache)
  {
    $this->entityTypeManager = $entity_type_manager;
    $this->cache = $cache;
  }

  /**
   * Get matching doc type form Hal references
   *
   * @param string $doc_type_id
   * @return striing
   */
  public function getDocTypeLabel(string $doc_type_id) {
    $labels = $this->getDocTypeLabels();
    return !empty($labels[$doc_type_id]) ? $labels[$doc_type_id] : $doc_type_id;
  }

  /**
   * Retrieves an array of HAL document types
   *
   * @return array
   */
  public function getDocTypeLabels() {
    $cid = 'hal_doc_type_labels';
    if ($cache = $this->cache->get($cid)) {
      $items = $cache->data;
    } else {
      $items = [];
      if($data = $this->getJsonData('https://api.archives-ouvertes.fr/ref/doctype')) {
        foreach($data['response']['result']['doc'] as $k => $arr) {
          $items[$arr['str'][0]] = $arr['str'][1];
        }
        $this->cache->set($cid, $items, -1, []);
      }
    }
    return $items;
  }

  /**
   * Gets referencs RAW data from HAL
   *
   * @param string $url
   * @return array
   */
  protected function getJsonData(string $url) {
    $data = [];
    $json = file_get_contents($url);
    if(!empty($json)) {
        $data = json_decode($json, true);
    }
    return $data;
  }

}
