<?php

namespace Drupal\search_api_hal\Plugin\facets\processor;

use Drupal\facets\FacetInterface;
use Drupal\facets\Processor\BuildProcessorInterface;
use Drupal\facets\Processor\ProcessorPluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\facets\FacetSource\SearchApiFacetSourceInterface;
use Drupal\search_api_hal\Helper;

/**
 * Provides a processor for HalFacetsLabelProcessor.
 *
 * @FacetsProcessor(
 *   id = "facets_hal_label",
 *   label = @Translation("Hal labels processor"),
 *   description = @Translation("Transforms Hal references such as docType etc.."),
 *   stages = {
 *     "build" = 50
 *   }
 * )
 */
class HalFacetsLabelProcessor extends ProcessorPluginBase implements BuildProcessorInterface, ContainerFactoryPluginInterface {

  /**
   * Hal helper
   *
   * @var \Drupal\search_api_hal\Helper
   */
  protected $halHelper;

  /**
   * Constructs a new object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\search_api_hal\Helper $hal_helper
   *   The hal halper
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, Helper $hal_helper) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->halHelper = $hal_helper;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('hal.helper')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build(FacetInterface $facet, array $results) {
    $hal_field_id = $this->getHalFieldName($facet);

    if(!empty($hal_field_id) && 'docType_s' == $hal_field_id) {
      /* @var \Drupal\facets\Result\Result $result */
      foreach ($results as $result) {
        $result->setDisplayValue($this->halHelper->getDocTypeLabel($result->getRawValue()));
      }
    }
    return $results;
  }

  /**
   * Get Hal field
   *
   * @param FacetInterface $facet
   * @return mixed
   */
  protected function getHalFieldName(FacetInterface $facet) {
    $facet_source = $facet->getFacetSource();
    if($facet_source instanceof SearchApiFacetSourceInterface) {
      $index = $facet_source->getIndex();
      $field = $index->getField($facet->getFieldIdentifier());
      $hal_field_id = $field->getPropertyPath();
      return $hal_field_id;
    }
    return;
  }

}
