<?php

namespace Drupal\search_api_hal\Plugin\views\field;

use Drupal\search_api\Plugin\views\field\SearchApiStandard;
use Drupal\views\Attribute\ViewsField;
use Drupal\Core\Url;

/**
 * Provides a handler for link field in Search API Views.
 *
 * @ingroup views_field_handlers
 */
#[ViewsField('search_api_link')]
class SearchApiLink extends SearchApiStandard {

  /**
   * {@inheritdoc}
   */
  public function render_item($count, $item) {
    $build = [
      '#type' => 'link',
      '#title' => $item['value'],
      '#url' => Url::fromUri($item['value']),
    ];
    $rendered = $this->getRenderer()->render($build);
    return $this->sanitizeValue($rendered);
  }

}
