<?php

namespace Drupal\search_api_hal;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\search_api\IndexInterface;
use Psr\Log\LoggerInterface;

/**
 * Decorates solr_field.manager to alter buildFieldDefinitionsFromSolr().
 */
class SolrFieldManagerDecorator extends \Drupal\search_api_solr\SolrFieldManager {

  /**
   * {@inheritdoc}
   */
  public function __construct(CacheBackendInterface $cache_backend, EntityTypeManagerInterface $entityTypeManager, LoggerInterface $logger) {
    parent::__construct($cache_backend, $entityTypeManager, $logger);
  }

  /**
   * {@inheritdoc}
   *
   * Override to alter field discovery from Solr.
   */
  protected function buildFieldDefinitionsFromSolr(IndexInterface $index) {
    // Call the original implementation first.
    $fields = parent::buildFieldDefinitionsFromSolr($index);

    // If this is hal server : set the label from the name property.
    $backend = $index->getServerInstanceIfAvailable()?->getBackendIfAvailable() ?? false;
    if($backend && ($backend->getPluginId() == 'search_api_hal')) {
      foreach ($fields as &$field) {
        $definition = $field->toArray();
        $field->setLabel($definition['name']);
      }
    }

    return $fields;
  }

}
