<?php

namespace Drupal\search_api_hal\Utility;

use Drupal\search_api\Utility\FieldsHelper;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\search_api\Utility\DataTypeHelperInterface;
use Drupal\search_api\Utility\ThemeSwitcherInterface;
use Drupal\search_api\IndexInterface;
use Symfony\Component\DependencyInjection\Container;

/**
 * Decorator for search_api.fields_helper to alter getNewFieldId().
 */
class FieldsHelperDecorator extends FieldsHelper {

  public function __construct(
    EntityTypeManagerInterface $entityTypeManager,
    EntityFieldManagerInterface $entityFieldManager,
    EntityTypeBundleInfoInterface $entityBundleInfo,
    DataTypeHelperInterface $dataTypeHelper,
    ?ThemeSwitcherInterface $themeSwitcher = NULL
  ) {
    parent::__construct($entityTypeManager, $entityFieldManager, $entityBundleInfo, $dataTypeHelper, $themeSwitcher);
  }

  /**
   * {@inheritdoc}
   */
  public function getNewFieldId(IndexInterface $index, $propertyPath) {
    // Use snake_case field names if this is a hal backend.
    $backend = $index->getServerInstanceIfAvailable()?->getBackendIfAvailable() ?? false;
    if($backend && ($backend->getPluginId() == 'search_api_hal')) {
      $propertyPath = Container::underscore($propertyPath);
      $propertyPath = str_replace('.', '_', $propertyPath);
    }
    return parent::getNewFieldId($index, $propertyPath);
  }

}
