<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\EventSubscriber;

use Drupal\search_api_opensearch\Event\QueryParamsEvent;
use Drupal\search_api_opensearch_semantic\Enum\SearchTypeEnum;
use Drupal\search_api_opensearch_semantic\Trait\SemanticIndexTrait;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to QueryParamsEvent to add min_score to query param.
 */
class QueryParamsEventSubscriber implements EventSubscriberInterface {

  use SemanticIndexTrait;

  /**
   * Adds min_score value if it is semantic search index.
   */
  public function onQueryParamsBuild(QueryParamsEvent $event): void {
    if ($this->isSemanticIndex($event->getQuery()->getIndex()->id()) === FALSE) {
      return;
    }
    $params = $event->getParams();
    // For hybrid search, we need to pass min_score in body rather than query.
    if ($event->getQuery()->getOption('search_type') === SearchTypeEnum::Hybrid) {
      $params['body']['min_score'] = $event->getQuery()->getOption('min_score') ?? 0;
    }

    // Pass search pipeline if search is hybrid search.
    if (($pipeline = $event->getQuery()->getIndex()->getThirdPartySetting('search_api_opensearch_semantic', 'search_pipeline')) !== NULL) {
      $params['search_pipeline'] = $pipeline;
    }
    $event->setParams($params);
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      QueryParamsEvent::class => ['onQueryParamsBuild'],
    ];
  }

}
