<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\Plugin\search_api\data_type;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\search_api\Attribute\SearchApiDataType;
use Drupal\search_api\Plugin\search_api\data_type\TextDataType;

/**
 * Provides the semantic field data type.
 *
 * @see https://docs.opensearch.org/docs/latest/field-types/supported-field-types/semantic/
 */
#[SearchApiDataType(
  id: Semantic::PLUGIN_ID,
  label: new TranslatableMarkup("Semantic"),
  description: new TranslatableMarkup("Specialized field type for semantic search."),
  fallback_type: "text"
)]
class Semantic extends TextDataType {

  public const string PLUGIN_ID = 'search_api_opensearch_semantic';

}
