<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\Trait;

use Drupal\search_api\Entity\Index;

/**
 * Trait for the search index related features for semantic search.
 */
trait SemanticIndexTrait {

  /**
   * Check if index is semantic index or not.
   */
  public function isSemanticIndex(string $indexName): bool {
    $index = Index::load($indexName);
    $modelId = $index->getThirdPartySetting('search_api_opensearch_semantic', 'model_id');
    if ($modelId === '' || $modelId === NULL) {
      return FALSE;
    }
    return TRUE;
  }

}
