<?php

declare(strict_types=1);

namespace Drupal\Tests\search_api_opensearch_semantic\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\search_api\Functional\ExampleContentTrait;

/**
 * Base class to test the search_api_opensearch_semantic datatype fields.
 */
class SearchApiOpenSearchSemanticTestBase extends KernelTestBase {

  use OpenSearchSemanticTestTrait;
  use ExampleContentTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'entity_test',
    'search_api',
    'search_api_opensearch',
    'search_api_opensearch_test',
    'search_api_test_example_content',
    'search_api_opensearch_semantic',
    'user',
    'field',
    'text',
  ];

  /**
   * {@inheritdoc}
   */
  protected string $serverId = 'opensearch_server';

  /**
   * {@inheritdoc}
   */
  protected string $indexId = 'test_opensearch_index';

  /**
   * The model ID used for testing.
   */
  protected string $modelId;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    // Setup test entity types.
    $this->installEntitySchema('entity_test_mulrev_changed');
    $this->setUpExampleStructure();

    // Setup search api.
    $this->installEntitySchema('search_api_task');
    $this->installConfig([
      'search_api',
      'search_api_opensearch',
      'search_api_opensearch_test',
      'search_api_test_example_content',
    ]);

    $this->modelId = $this->registerModel();
    $this->getIndex()
      ->setThirdPartySetting('search_api_opensearch_semantic', 'knn', TRUE)
      ->setThirdPartySetting('search_api_opensearch_semantic', 'model_id', $this->modelId)
      ->save();
    $this->recreateIndex();
  }

  /**
   * {@inheritdoc}
   */
  public function tearDown(): void {
    // Unregister the model after tests.
    if ($this->modelId) {
      $osClient = $this->getBackend()->getClient();
      $osClient->ml()->deleteModel(['id' => $this->modelId]);
    }
    parent::tearDown();
  }

  /**
   * Register a model for testing.
   *
   * @todo register a very small custom model.
   */
  protected function registerModel(): string {
    $osClient = $this->getBackend()->getClient();
    $osClient->cluster()->putSettings([
      'body' => [
        'transient' => [
          'plugins.ml_commons.only_run_on_ml_node' => 'false',
        ],
      ],
    ]);

    $modelResponse = $osClient->ml()->registerModel([
      'body' => [
        'name' => 'huggingface/sentence-transformers/all-MiniLM-L6-v2',
        'version' => '1.0.2',
        'model_format' => 'TORCH_SCRIPT',
      ],
    ]);

    $taskId = $modelResponse['task_id'];
    $retries = 0;
    do {
      $task = $osClient->ml()->getTask(['id' => $taskId]);
      if ($task['state'] === 'COMPLETED' || $task['state'] === 'FAILED') {
        break;
      }
      $retries++;
      sleep(10);
    } while ($retries < 10);

    return $task['model_id'] ?? throw new \RuntimeException('Could not create model');
  }

}
