<?php

declare(strict_types=1);

namespace Drupal\Tests\search_api_opensearch_semantic\Kernel;

use Drupal\field\Entity\FieldStorageConfig;
use Drupal\search_api_opensearch_semantic\Plugin\search_api\data_type\Semantic;

/**
 * Tests the semantic field.
 *
 * @group search_api_opensearch_semantic
 */
class SemanticFieldTest extends SearchApiOpenSearchSemanticTestBase {

  /**
   * Tests the semantic field.
   */
  public function testSemanticField(): void {
    $body = FieldStorageConfig::loadByName('entity_test_mulrev_changed', 'body');
    /** @var \Drupal\search_api\Utility\FieldsHelperInterface $fieldsHelper */
    $fieldsHelper = \Drupal::service('search_api.fields_helper');
    $index = $this->getIndex();
    $field = $fieldsHelper->createFieldFromProperty($index, $body->getPropertyDefinition('value'), 'entity:entity_test_mulrev_changed', 'body', 'body1', Semantic::PLUGIN_ID);
    $index->addField($field)->save();
    /** @var \Drupal\search_api_opensearch\Plugin\search_api\backend\OpenSearchBackend $backend */
    $backend = $this->getBackend();
    $backend->getBackendClient()->updateIndex($index);
    $mapping = $backend->getClient()->indices()->getMapping([
      'index' => $backend->getBackendClient()->getIndexId($index),
    ]);
    $properties = $mapping['test_test_opensearch_index']['mappings']['properties'];
    $this->assertSame('semantic', $properties['body1']['type']);
    $this->assertArrayHasKey('body1_semantic_info', $properties);
  }

}
