<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\EventSubscriber;

use Drupal\search_api_opensearch\Event\BeforeIndexCreateEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to AlterSettingsEvent to enable vector indices.
 */
class VectorIndexEventSubscriber implements EventSubscriberInterface {

  /**
   * Enables vector index settings if configured.
   */
  public function onBeforeIndexCreate(BeforeIndexCreateEvent $event): void {
    $settings = $event->getSettings();
    $index = $event->getIndex();
    if ($index->getThirdPartySetting('search_api_opensearch_semantic', 'knn')) {
      $settings['index.knn'] = TRUE;
    }
    $event->setSettings($settings);
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      BeforeIndexCreateEvent::class => ['onBeforeIndexCreate'],
    ];
  }

}
