<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\search_api\Item\FieldInterface;
use Drupal\search_api_opensearch_semantic\Plugin\search_api\data_type\Semantic;

/**
 * Alter index param values before sending to opensearch.
 */
class IndexParamValueHooks {

  /**
   * Implements hook_index_param_value_alter().
   */
  #[Hook('index_param_value_alter')]
  public function indexParamValueAlter(array &$originalValue, FieldInterface $field): void {
    if ($field->getType() !== Semantic::PLUGIN_ID) {
      return;
    }
    $originalValue = \implode(', ', $originalValue);
  }

}
