<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\Hook;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\search_api\Entity\Index;
use Drupal\search_api_opensearch_semantic\Plugin\views\filter\SearchApiHybridSemantic;
use Drupal\search_api_opensearch_semantic\Plugin\views\filter\SearchApiSemantic;

/**
 * Views data hooks for views related plugins.
 */
class ViewsData {

  use StringTranslationTrait;

  /**
   * Constructs ViewsData object.
   */
  public function __construct(protected ModuleHandlerInterface $moduleHandler) {}

  /**
   * Implements hook_views_data().
   */
  #[Hook('views_data_alter')]
  public function viewsDataAlter(array &$data): void {
    // @phpstan-ignore-next-line
    $this->moduleHandler->loadInclude('search_api', 'inc', 'views_hooks');
    /** @var \Drupal\search_api\IndexInterface $index */
    foreach (Index::loadMultiple() as $index) {
      $key = 'search_api_index_' . $index->id();
      $table = &$data[$key];
      $fulltext_field = _search_api_views_find_field_alias('search_api_fulltext_semantic', $table);
      $table[$fulltext_field]['group'] = $this->t('Search');
      $table[$fulltext_field]['title'] = $this->t('Fulltext semantic search');
      $table[$fulltext_field]['help'] = $this->t('Search several or all fulltext fields with semantic search.');
      $table[$fulltext_field]['filter']['id'] = SearchApiSemantic::PLUGIN_ID;
      $table[$fulltext_field]['argument']['id'] = 'search_api_fulltext';
      if ($fulltext_field != 'search_api_fulltext') {
        $table[$fulltext_field]['real field'] = 'search_api_fulltext';
      }

      $fulltext_field = _search_api_views_find_field_alias('search_api_semantic_hybrid', $table);
      $table[$fulltext_field]['group'] = $this->t('Search');
      $table[$fulltext_field]['title'] = $this->t('Fulltext hybrid search (Semantic + Normal)');
      $table[$fulltext_field]['help'] = $this->t('Search several or all fulltext fields with semantic and hybrid search.');
      $table[$fulltext_field]['filter']['id'] = SearchApiHybridSemantic::PLUGIN_ID;
      $table[$fulltext_field]['argument']['id'] = 'search_api_fulltext';
      if ($fulltext_field != 'search_api_fulltext') {
        $table[$fulltext_field]['real field'] = 'search_api_fulltext';
      }
    }
  }

}
