<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\Plugin\search_api\data_type;

use Drupal\search_api\Plugin\search_api\data_type\TextDataType;

/**
 * Provides the semantic field data type.
 *
 * @SearchApiDataType(
 *   id = \Drupal\search_api_opensearch_semantic\Plugin\search_api\data_type\Semantic::PLUGIN_ID,
 *   label = @Translation("Semantic"),
 *   description = @Translation("Specialized field type for semantic search."),
 *   fallback_type = "text"
 * )
 *
 * @see https://docs.opensearch.org/docs/latest/field-types/supported-field-types/semantic/
 */
class Semantic extends TextDataType {

  public const string PLUGIN_ID = 'search_api_opensearch_semantic';

}
