<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\EventSubscriber;

use Drupal\search_api_opensearch\Event\FieldMappingEvent;
use Drupal\search_api_opensearch_semantic\Plugin\search_api\data_type\Semantic;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to the field mapping event to add semantic field.
 *
 * This subscriber modifies the field mapping parameters for semantic fields
 * to ensure they are correctly configured for OpenSearch.
 */
class SemanticFieldMappingEventSubscriber implements EventSubscriberInterface {

  /**
   * Handles the field mapping event to add semantic fields.
   */
  public function onFieldMapping(FieldMappingEvent $event): void {
    $field = $event->getField();
    if ($field->getType() === Semantic::PLUGIN_ID) {
      $param = $event->getParam();
      $param['type'] = 'semantic';
      $param['model_id'] = $event->getField()->getIndex()->getThirdPartySetting('search_api_opensearch_semantic', 'model_id');
      $param['raw_field_type'] = 'text';
      $param['boost'] = $field->getBoost();
      if (!empty($field->getConfiguration()['chunking'])) {
        $param['chunking'] = TRUE;
      }
      $event->setParam($param);
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      FieldMappingEvent::class => ['onFieldMapping'],
    ];
  }

}
