<?php

declare(strict_types=1);

namespace Drupal\search_api_opensearch_semantic\Plugin\views\filter;

use Drupal\search_api\Plugin\views\filter\SearchApiFilterTrait;
use Drupal\search_api_opensearch_semantic\Enum\SearchTypeEnum;
use Drupal\views\Attribute\ViewsFilter;

/**
 * Defines a filter for adding a fulltext hybrid search to the view.
 */
#[ViewsFilter(
  id: self::PLUGIN_ID,
)]
class SearchApiHybridSemantic extends SearchApiSemanticSearchFilterBase {

  use SearchApiFilterTrait;

  public const string PLUGIN_ID = 'search_api_semantic_hybrid';

  /**
   * {@inheritdoc}
   */
  public function defineOptions(): array {
    $options = parent::defineOptions();
    $options['hybrid_search'] = TRUE;
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function query(): void {
    while (\is_array($this->value)) {
      $this->value = $this->value ? reset($this->value) : '';
    }
    // Catch empty strings entered by the user, but not "0".
    if ($this->value === '') {
      return;
    }
    $fields = $this->options['fulltext_fields'];
    $query = $this->getQuery();

    if ($this->options['parse_mode']) {
      /** @var \Drupal\search_api\ParseMode\ParseModeInterface $parse_mode */
      $parse_mode = $this->getParseModeManager()
        ->createInstance($this->options['parse_mode']);
      $query->setParseMode($parse_mode);
    }

    // @todo Check if we can remove this. We are mainly using in ParamBuilder.
    $query->setFulltextFields($fields);

    // Following options are used in SemanticSearchParamBuilder query builder.
    $query->setOption('min_score', $this->options['min_score']);
    $query->setOption('search_type', SearchTypeEnum::Hybrid);
    $query->setOption('fulltext_fields', $this->options['fulltext_fields']);
    $query->setOption('semantic_field', $this->options['semantic_field']);
    $query->keys($this->value);
  }

}
