# Search API Pin By Phrase

**Search API Pin By Phrase** allows site builders to *pin* specific nodes to the
top of Search API Solr search results when the user’s search query exactly
matches a configured phrase. Each rule maps:

- Exact phrase  
- Node ID  
- (Optional) Language code  

When the phrase matches the user’s search, the specified node(s) will be moved
to the top of the result set while preserving the original sort order for the
remaining items.

This module is especially useful for:
- Highlighting key landing pages  
- Promoting most-important internal resources  
- Providing curated results for known “top tasks”  
- Multilingual search behavior tuning  

---

## Features

- Unlimited configurable phrase → node ID → langcode mappings  
- Case-insensitive exact phrase matching  
- Optional language-specific mapping  
- Per-view activation (avoid affecting autocomplete, admin views, etc.)  
- Unlimited dynamic configuration rows (add/remove)  
- No patches required — pure Drupal APIs  
- Fully compatible with Drupal 10 and Drupal 11  
- Lightweight: affects only result reordering, not indexing  

---

## Requirements

- Drupal Core **10 or 11**
- [Search API](https://www.drupal.org/project/search_api)
- [Search API Solr](https://www.drupal.org/project/search_api_solr) 4.3 or newer
- A working Solr backend configured with Search API

---

## Installation

Install the module as usual:

```bash
composer require drupal/search_api_pinbyphrase

