<?php

declare(strict_types=1);

namespace Drupal\search_api_pinbyphrase\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\search_api\IndexInterface;

/**
 * Lists Search API indexes with links to the Pin By Phrase settings form.
 */
final class PinByPhraseController extends ControllerBase {

  /**
   * Builds an overview of indexes that can be configured.
   *
   * @return array
   *   A render array.
   */
  public function selectindex(): array {
    /** @var \Drupal\search_api\IndexInterface[] $indexes */
    $indexes = $this->entityTypeManager()
      ->getStorage('search_api_index')
      ->loadMultiple();

    $rows = [];
    foreach ($indexes as $index) {
      if (!$index instanceof IndexInterface) {
        continue;
      }

      $url = Url::fromRoute('search_api_pinbyphrase.settings', [
        'search_api_index' => $index->id(),
      ]);

      $rows[] = [
        'data' => [
          [
            'data' => $index->label(),
          ],
          [
            'data' => Link::fromTextAndUrl($this->t('Configure'), $url)
              ->toRenderable(),
          ],
        ],
      ];
    }

    return [
      '#title' => $this->t('Pin By Phrase configuration'),
      'description' => [
        '#markup' => $this->t('Configure phrases that should pin specific nodes to the top of the search results. Settings are global and apply to all Search API indexes.'),
      ],
      'indexes' => [
        '#type' => 'table',
        '#header' => [
          $this->t('Index'),
          $this->t('Operations'),
        ],
        '#rows' => $rows,
        '#empty' => $this->t('There are no Search API indexes to configure.'),
      ],
    ];
  }

}
