# Search API Remote Management

## Introduction

This module provides a powerful solution for centralizing the management of Search API indexes across multiple Drupal sites. It allows administrators to control and monitor indexing operations on various "endpoint" sites from a single, central "management" site.

The module is split into two main components:

*   **Search API Remote (`search_api_remote`)**: This is the "endpoint" module. You install it on every Drupal site whose Search API indexes you want to manage remotely. It exposes a secure REST API to perform operations like re-indexing, clearing, and checking the status of any local Search API index.
*   **Search API Remote Admin (`search_api_remote_admin`)**: This is the "management UI" module. You install it on a single, central Drupal site. It provides a user interface to configure connections to your endpoint sites and trigger remote operations on their indexes.

## Features

*   Remotely trigger a full re-index of any Search API index.
*   Remotely clear all items from an index.
*   Remotely check the indexing status (total items, indexed items, percentage complete).
*   Remotely trigger the processing of the indexing queue.
*   A centralized UI to view and manage indexes from multiple sites.
*   Connections are secured using Basic Authentication.

## Requirements

*   Drupal ^10 or ^11
*   [Search API](https://www.drupal.org/project/search_api)
*   Core **Basic Auth** module (`basic_auth`)

---

## Installation and Configuration

The setup involves configuring two types of sites: the sites you want to manage (Endpoints) and the site where you manage them from (Admin).

### 1. On Each Site to be Managed (Endpoint Site)

On every Drupal site that has indexes you want to control remotely:

1.  Install and enable the **Search API Remote (`search_api_remote`)** module.
2.  Enable the core **Basic Auth** module.
3.  Create a new, dedicated user account for the API (e.g., `remote_admin`).
4.  Grant this user the **"Administer Search API Remote"** permission. Do not grant it any other permissions unless necessary.
5.  Take note of the username and password for this user.

This site now exposes a secure API at `/api/search-api-remote/{search_api_index_id}/{operation}`.

### 2. On the Central Management Site (Admin Site)

On the single Drupal site you will use to manage all the others:

1.  Install and enable the **Search API Remote Admin (`search_api_remote_admin`)** module. This will automatically enable the base `search_api_remote` module as well.
2.  Navigate to the configuration page: **Configuration > Search and metadata > Search API Remote Indexes** (`/admin/config/search/search-api-remote-index`).
3.  Click **"Add Search API Remote Index"**.
4.  Fill in the form fields:
    *   **Label**: A human-readable name for this remote index (e.g., "Blog Production - Articles Index").
    *   **Endpoint URL**: The full URL pointing to the specific index on the endpoint site. For example: `https://my-endpoint-site.com/api/search-api-remote/articles`.
    *   **Authentication Type**: Select "Basic Auth".
    *   **Username**: The username of the dedicated API user you created on the endpoint site (e.g., `remote_admin`).
    *   **Password**: The password for the API user.

5.  Save the configuration.

Repeat step 4 for every remote index you want to manage.

---

## Usage

Once configured, all remote indexes will be listed at `/admin/config/search/search-api-remote-index`.

From this page, you can:
*   See all configured remote indexes.
*   Use the **"Actions"** button next to each index to trigger remote operations like `Status`, `Re-index`, `Clear`, and `Process`. The results of the operation will be displayed in a modal.
