<?php

namespace Drupal\search_api_remote_admin\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * An AJAX command for instructing the client to continue the processing loop.
 */
class ContinueProcessingCommand implements CommandInterface {

  /**
   * The selector for the element to trigger.
   *
   * @var string
   */
  protected $selector;

  /**
   * Constructs a new ContinueProcessingCommand.
   *
   * @param string $selector
   *   The jQuery selector of the button to click.
   */
  public function __construct($selector) {
    $this->selector = $selector;
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'continueProcessing',
      'selector' => $this->selector,
    ];
  }

}
