<?php

namespace Drupal\search_api_remote_admin\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the Search API Remote Index entity.
 *
 * @ConfigEntityType(
 *   id = "search_api_remote_index",
 *   label = @Translation("Search API Remote Index"),
 *   handlers = {
 *     "list_builder" = "Drupal\search_api_remote_admin\SearchApiRemoteIndexListBuilder",
 *     "form" = {
 *       "add" = "Drupal\search_api_remote_admin\Form\SearchApiRemoteIndexForm",
 *       "edit" = "Drupal\search_api_remote_admin\Form\SearchApiRemoteIndexForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     }
 *   },
 *   config_prefix = "search_api_remote_index",
 *   admin_permission = "administer search api remote indexes",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "collection" = "/admin/config/search/search-api-remote-index",
 *     "edit-form" = "/admin/config/search/search-api-remote-index/{search_api_remote_index}/edit",
 *     "delete-form" = "/admin/config/search/search-api-remote-index/{search_api_remote_index}/delete"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "endpoint_url",
 *     "auth_type",
 *     "auth_config",
 *     "batch_size"
 *   }
 * )
 */
class SearchApiRemoteIndex extends ConfigEntityBase implements SearchApiRemoteIndexInterface {

  /**
   * The Search API Remote Index ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Search API Remote Index label.
   *
   * @var string
   */
  protected $label;

  /**
   * The endpoint URL.
   *
   * @var string
   */
  protected $endpoint_url;

  /**
   * The authentication type.
   *
   * @var string
   */
  protected $auth_type = 'none';

  /**
   * The authentication configuration.
   *
   * @var array
   */
  protected $auth_config = [];

  /**
   * The batch size.
   *
   * @var int
   */
  protected $batch_size = 50;

  /**
   * {@inheritdoc}
   */
  public function getEndpointUrl() {
    return $this->endpoint_url;
  }

  /**
   * {@inheritdoc}
   */
  public function getAuthType() {
    return $this->auth_type;
  }

  /**
   * {@inheritdoc}
   */
  public function getAuthConfig() {
    return $this->auth_config;
  }

  /**
   * {@inheritdoc}
   */
  public function getBatchSize() {
    return $this->batch_size;
  }

}
