<?php

namespace Drupal\search_api_remote_admin\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining Search API Remote Index entities.
 */
interface SearchApiRemoteIndexInterface extends ConfigEntityInterface {

  /**
   * Gets the Endpoint URL.
   *
   * @return string
   *   The Endpoint URL.
   */
  public function getEndpointUrl();

  /**
   * Gets the authentication type.
   *
   * @return string
   *   The authentication type ('none', 'basic_auth', 'token').
   */
  public function getAuthType();

  /**
   * Gets the authentication configuration.
   *
   * @return array
   *   The authentication configuration.
   */
  public function getAuthConfig();

  /**
   * Gets the batch size.
   *
   * @return int
   *   The batch size.
   */
  public function getBatchSize();

}
