# Search API Site Studio Processor

## 🔍 Overview and Purpose

This module adds a Search API processor to decode Acquia Site Studio content, ensuring all text from custom and default components is fully indexed and searchable.

For sites using Site Studio (formerly Cohesion) to build content using components and layouts, this module solves a common search issue: standard search indexing often misses content embedded within these custom component structures. Our processor acts as the necessary translator to make that rich, designed content discoverable.

## 💡 Solution Provided

This Search API processor makes all Acquia Site Studio content searchable. You can choose to index all components, or precisely filter the content by component category or single component for accurate, controlled search results.

## ⚙️ Configuration Guide

The configuration process is fast, giving you immediate control over your search index.

## 3-Step Setup Process

* Module Installation: Install the module using the standard Drupal installation process (Composer is recommended).

* Add the Index Field: Navigate to the configuration page for your chosen Search API index. You must add a new field to the index and name it "Sitestudio Components". This field is required as the anchor point for the processor to inject the decoded Site Studio content.

* Initial Indexing: Once the field is added, the processor is automatically active and will run upon the next index operation.

## Key Feature: Granular Control

By default, the processor is configured to index all text content found within every Sitestudio component on the page, ensuring maximum coverage.

If you need more control, you can adjust the processor's settings within the Search API configuration interface:

* Filter by Component Category: Only index content from specific groups of components (e.g., only "Articles" components).

* Filter by Single Component: Only index content from a specific, individual component (e.g., only the "Hero Banner" component).

This filtering capability is essential for managing index size and ensuring high search result relevance.