<?php

declare(strict_types=1);

namespace Drupal\search_api_solr_dense_vector\EventSubscriber;

use Drupal\search_api_solr\Event\PostConfigFilesGenerationEvent;
use Drupal\search_api_solr\Event\SearchApiSolrEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Alters the config to add dynamic fields for DenseVector fields.
 */
class SearchApiSolrDenseVectorConfigSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      SearchApiSolrEvents::POST_CONFIG_FILES_GENERATION => 'postConfigFilesGeneration',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function postConfigFilesGeneration(PostConfigFilesGenerationEvent $event): void {
    $files = $event->getConfigFiles();

    if (isset($files['schema_extra_fields.xml'])) {
      $knn_field = '<dynamicField name="knn_*" type="knn_vector" stored="true" indexed="true" multiValued="false" />';
      $knn_field .= PHP_EOL . '<dynamicField name="knns_*" type="knn_vector" stored="true" indexed="true" multiValued="false" />';
      $files['schema_extra_fields.xml'] = preg_replace('/(^.*(type="knn_vector").*(multiValued="true").*$\n)/m', '', $files['schema_extra_fields.xml']);
      $files['schema_extra_fields.xml'] = $files['schema_extra_fields.xml'] . PHP_EOL . $knn_field;
    }

    $event->setConfigFiles($files);
  }

}
