# Search API Solr Dense Vector

This module adds Dense Vector field support for Solr based indexes with
Search API. It includes the field types needed as well as an index processor
that can:

- Use the Drupal AI framework to allow provider selection
- Select from any embedding model from a selected AI provider
- Make vector dimension configurable
- Make similarity function configurable
- Make topK configurable

For a full description of the module, visit the
[project page](https://www.drupal.org/project/search_api_solr_dense_vector).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search_api_solr_dense_vector).


## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers

## Requirements

This module requires Search API Solr 4+, Solr 9.5+, the Drupal AI module and
at least one AI Provider module, like OpenAI or Gemini.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. Enable and configure Search API Solr, Drupal AI module and an AI Provider.
2. Enable the Search API Solr Dense Vector module.
3. Follow the Search API Solr docs on how to create a collection and upload
   a configset.
4. Add an index, and add some fields to it.
5. For the vector field, select the field to create a vector out of and set
   its type as DenseVector.
6. On the processors tab, toggle on DenseVector and set its configuration
   options at the bottom of the admin screen.
7. Run the indexer.
8. Search queries will now take user input from fulltext fields or keys
   (Views or otherwise), create a vector from that and compare that to
   vectors embeddings in your Solr documents. To see how this works, look at
   the SearchApiSolrDenseVectorQuerySubscriber event subscriber in this module.

## Maintainers

- Kevin Quillen [kevinquillen](https://www.drupal.org/u/kevinquillen)
