<?php

namespace Drupal\search_api_solr_dense_vector\Plugin\search_api\data_type\value;

/**
 * Represents a single dense vector value.
 */
class DenseVectorValue implements DenseVectorValueInterface {

  /**
   * The vector values.
   *
   * @var array
   */
  protected $vectors;

  /**
   * Constructs a DenseVectorValue object.
   *
   * @param array $vectors
   *   The vectors.
   */
  public function __construct(array $vectors) {
    $this->vectors = $vectors;
  }

  /**
   * {@inheritdoc}
   */
  public function getVectors(): array {
    return $this->vectors;
  }

}
