<?php

declare(strict_types=1);

namespace Drupal\search_api_solr_dense_vector;

use Solarium\QueryType\Select\Query\Query as SolariumQueryInterface;

/**
 * Defines an interface for SolrRanker plugins.
 */
interface DenseVectorRankerInterface {

  /**
   * Processes the Solarium query to apply ranking logic.
   *
   * @param \Solarium\QueryType\Select\Query\Query $query
   *   The Solarium query to process.
   * @param string $solr_field
   *   The dense vector solr field.
   * @param int $top_k
   *   The number of top results to return.
   * @param array $vectors
   *   The vector values for the current search.
   *
   * @return \Solarium\QueryType\Select\Query\Query
   *   The processed Solarium query.
   */
  public function apply(SolariumQueryInterface $query, string $solr_field, int $top_k, array $vectors): SolariumQueryInterface;

}
