<?php

declare(strict_types=1);

namespace Drupal\search_api_solr_dense_vector;

use Drupal\Component\Plugin\PluginBase;
use Solarium\QueryType\Select\Query\Query as SolariumQueryInterface;

/**
 * Base class for DenseVectorRanker plugins.
 */
abstract class DenseVectorRankerPluginBase extends PluginBase implements DenseVectorRankerInterface {

  /**
   * {@inheritdoc}
   */
  abstract public function apply(SolariumQueryInterface $query, string $solr_field, int $top_k, array $vectors): SolariumQueryInterface;

}
