<?php

declare(strict_types=1);

namespace Drupal\search_api_solr_dense_vector;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\search_api_solr_dense_vector\Attribute\DenseVectorRanker;

/**
 * Provides a plugin manager for SolrRanker plugins.
 */
class DenseVectorRankerPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new SolrRankerPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(
    \Traversable $namespaces,
    protected CacheBackendInterface $cache_backend,
    protected ModuleHandlerInterface $module_handler,
  ) {
    parent::__construct(
      'Plugin/search_api_solr_dense_vector/query_ranker',
      $namespaces,
      $module_handler,
      DenseVectorRankerInterface::class,
      DenseVectorRanker::class,
    );

    $this->alterInfo('dense_vector_ranker_info');
    $this->setCacheBackend($cache_backend, 'dense_vector_ranker_plugins');
  }

}
