<?php

declare(strict_types=1);

namespace Drupal\search_api_solr_dense_vector\Plugin\search_api_solr_dense_vector\query_ranker;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\search_api_solr_dense_vector\Attribute\DenseVectorRanker;
use Drupal\search_api_solr_dense_vector\DenseVectorRankerPluginBase;
use Solarium\QueryType\Select\Query\Query as SolariumQueryInterface;

/**
 * Pure vector search ranker.
 *
 * This plugin overwrites the main query for a vector search comparison.
 */
#[DenseVectorRanker(
  id: 'pure_vector',
  label: new TranslatableMarkup('Pure Vector'),
)]
class PureVector extends DenseVectorRankerPluginBase {

  /**
   * {@inheritdoc}
   */
  public function apply(SolariumQueryInterface $query, string $solr_field, int $top_k, array $vectors): SolariumQueryInterface {
    return $query->setQuery('{!knn f=' . $solr_field . ' topK=' . $top_k . '}[' . implode(', ', $vectors[0]) . ']');
  }

}
