<?php

declare(strict_types=1);

namespace Drupal\search_api_solr_dense_vector;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Core\Plugin\PluginFormInterface;
use Solarium\QueryType\Select\Query\Query as SolariumQueryInterface;

/**
 * Defines an interface for SolrRanker plugins.
 */
interface DenseVectorRankerInterface extends PluginFormInterface, ConfigurableInterface {

  /**
   * Processes the Solarium query to apply ranking logic.
   *
   * @param \Solarium\QueryType\Select\Query\Query $query
   *   The Solarium query to process.
   * @param string $solr_field
   *   The dense vector solr field.
   * @param array $vectors
   *   The vector values for the current search.
   *
   * @return \Solarium\QueryType\Select\Query\Query
   *   The processed Solarium query.
   */
  public function apply(SolariumQueryInterface $query, string $solr_field, array $vectors): SolariumQueryInterface;

}
