<?php

declare(strict_types=1);

namespace Drupal\search_api_solr_dense_vector\Plugin\search_api_solr_dense_vector\query_ranker;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\search_api_solr_dense_vector\Attribute\DenseVectorRanker;
use Drupal\search_api_solr_dense_vector\DenseVectorRankerPluginBase;
use Solarium\QueryType\Select\Query\Query as SolariumQueryInterface;

/**
 * Pure vector search ranker.
 *
 * This plugin overwrites the main query for a vector search comparison.
 */
#[DenseVectorRanker(
  id: 'pure_vector',
  label: new TranslatableMarkup('Pure Vector'),
)]
class PureVector extends DenseVectorRankerPluginBase {

  /**
   * {@inheritdoc}
   */
  public function apply(SolariumQueryInterface $query, string $solr_field, array $vectors): SolariumQueryInterface {
    $configuration = $this->getConfiguration();
    $minimum_traverse = ((int) $configuration['minimum_traverse'] > 0) ? $configuration['minimum_traverse'] : '-Infinity';
    return $query->setQuery('{!knn f=' . $solr_field . ' topK=' . $configuration['top_k'] . ' minReturn=' . $configuration['minimum_return'] . ' minTraverse=' . $minimum_traverse . '}[' . implode(', ', $vectors[0]) . ']');
  }

}
