<?php

/**
 * @file
 * PHPStan stub file for Search API Autocomplete interfaces.
 *
 * These stubs allow PHPStan to analyze autocomplete functionality
 * without requiring the search_api_autocomplete module to be installed.
 */

declare(strict_types=1);

namespace Drupal\search_api_autocomplete;

/**
 * Stub for SearchInterface.
 */
interface SearchInterface {

  /**
   * Get an option value.
   *
   * @param string $name
   *   The option name.
   *
   * @return mixed
   *   The option value.
   */
  public function getOption(string $name): mixed;

}

namespace Drupal\search_api_autocomplete\Suggestion;

/**
 * Stub for SuggestionInterface.
 */
interface SuggestionInterface {

  /**
   * Get the suggestion text.
   *
   * @return string|null
   *   The suggested text.
   */
  public function getSuggestedKeys(): ?string;

}

/**
 * Stub for Suggestion class.
 */
class Suggestion implements SuggestionInterface {

  /**
   * Constructs a Suggestion object.
   *
   * @param string|null $suggested_keys
   *   The suggested keys.
   * @param string|null $label
   *   The label.
   * @param string|null $url
   *   The URL.
   */
  public function __construct(
    ?string $suggested_keys = NULL,
    ?string $label = NULL,
    ?string $url = NULL
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getSuggestedKeys(): ?string {
    return NULL;
  }

}
