<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Search;

/**
 * Defines the interface for building facet queries.
 */
interface FacetBuilderInterface {

  /**
   * Calculates facet counts for a field.
   *
   * @param string $index_id
   *   The Search API index ID.
   * @param string $field_name
   *   The field name to facet on.
   * @param array<string> $item_ids
   *   Item IDs to calculate facets for (from search results).
   * @param array<string, mixed> $options
   *   Facet options:
   *   - limit: Maximum number of facet values.
   *   - min_count: Minimum count to include a facet value.
   *   - missing: Whether to include count of items without a value.
   *
   * @return array<array{value: mixed, count: int}>
   *   Array of facet values with counts.
   */
  public function calculateFacets(
    string $index_id,
    string $field_name,
    array $item_ids,
    array $options = [],
  ): array;

  /**
   * Calculates facets for multiple fields at once.
   *
   * @param string $index_id
   *   The Search API index ID.
   * @param array<string, array<string, mixed>> $field_options
   *   Map of field names to their facet options.
   * @param array<string> $item_ids
   *   Item IDs to calculate facets for.
   *
   * @return array<string, array<array{value: mixed, count: int}>>
   *   Map of field names to their facet results.
   */
  public function calculateMultipleFacets(
    string $index_id,
    array $field_options,
    array $item_ids,
  ): array;

}
