<?php

/**
 * @file
 * PHPStan stub file for Search API interfaces.
 *
 * These stubs provide missing iterable value type information that
 * Search API's interfaces don't specify.
 */

declare(strict_types=1);

namespace Drupal\search_api\Item;

/**
 * Stub for FieldInterface to specify iterable value type.
 *
 * @extends \Traversable<int, mixed>
 */
interface FieldInterface extends \Traversable {

  /**
   * Get field values.
   *
   * @return array<int, mixed>
   */
  public function getValues(): array;

  /**
   * Get field type.
   */
  public function getType(): string;

  /**
   * Get field boost.
   */
  public function getBoost(): float;

}

/**
 * Stub for ItemInterface to specify iterable value type.
 *
 * @extends \Traversable<string, FieldInterface>
 */
interface ItemInterface extends \Traversable {

  /**
   * Get a field from the item.
   *
   * @param string $field_id
   *   The field ID.
   * @param bool $extract
   *   Whether to extract the field if not yet extracted.
   */
  public function getField(string $field_id, bool $extract = TRUE): ?FieldInterface;

  /**
   * Get all fields from the item.
   *
   * @return \Drupal\search_api\Item\FieldInterface[]
   */
  public function getFields(): array;

  /**
   * Get the datasource ID.
   */
  public function getDatasourceId(): ?string;

  /**
   * Get the item language.
   */
  public function getLanguage(): ?string;

  /**
   * Set the item score.
   *
   * @param float $score
   *   The score.
   *
   * @return $this
   */
  public function setScore(float $score);

  /**
   * Get the item score.
   *
   * @return float
   *   The score.
   */
  public function getScore(): float;

  /**
   * Get the item ID.
   */
  public function getId(): string;

  /**
   * Set extra data on the item.
   *
   * @param string $key
   *   The key.
   * @param mixed $data
   *   The data.
   *
   * @return $this
   */
  public function setExtraData(string $key, mixed $data = NULL);

  /**
   * Get extra data from the item.
   *
   * @param string $key
   *   The key.
   * @param mixed $default
   *   The default value.
   */
  public function getExtraData(string $key, mixed $default = NULL): mixed;

}

namespace Drupal\search_api\Query;

use Drupal\search_api\Item\ItemInterface;

/**
 * Stub for ConditionInterface.
 */
interface ConditionInterface {

  /**
   * Get the field name.
   */
  public function getField(): string;

  /**
   * Get the value.
   *
   * @return mixed
   */
  public function getValue(): mixed;

  /**
   * Get the operator.
   */
  public function getOperator(): string;

}

/**
 * Stub for ConditionGroupInterface.
 */
interface ConditionGroupInterface {

  /**
   * Get the conditions.
   *
   * @return array<int, ConditionInterface|ConditionGroupInterface>
   */
  public function getConditions(): array;

  /**
   * Get the conjunction (AND or OR).
   */
  public function getConjunction(): string;

}

/**
 * Stub for ResultSetInterface to specify iterable value type.
 *
 * @extends \Traversable<string, ItemInterface>
 */
interface ResultSetInterface extends \Traversable {

  /**
   * Get the result count.
   */
  public function getResultCount(): ?int;

  /**
   * Set the result count.
   *
   * @param int $count
   *   The count.
   *
   * @return $this
   */
  public function setResultCount(int $count);

  /**
   * Add a result item.
   *
   * @param \Drupal\search_api\Item\ItemInterface $item
   *   The item.
   *
   * @return $this
   */
  public function addResultItem(ItemInterface $item);

  /**
   * Get the result items.
   *
   * @return array<string, \Drupal\search_api\Item\ItemInterface>
   */
  public function getResultItems(): array;

  /**
   * Set extra data on the result set.
   *
   * @param string $key
   *   The key.
   * @param mixed $data
   *   The data.
   *
   * @return $this
   */
  public function setExtraData(string $key, mixed $data = NULL);

  /**
   * Get extra data from the result set.
   *
   * @param string $key
   *   The key.
   * @param mixed $default
   *   The default value.
   */
  public function getExtraData(string $key, mixed $default = NULL): mixed;

}
