<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Utility;

use Psr\Log\LoggerInterface;

/**
 * Provides verbose logging functionality.
 *
 * Classes using this trait must implement getVerboseLogger() and
 * getVerboseLoggerConfig() methods to provide the logger and configuration.
 */
trait VerboseLoggerTrait {

  /**
   * Logs an informational message if verbose logging is enabled.
   *
   * @param string $message
   *   The log message.
   * @param array<string, mixed> $context
   *   The log context.
   */
  protected function logVerbose(string $message, array $context = []): void {
    $config = $this->getVerboseLoggerConfig();
    if ($config['verbose_logging'] ?? FALSE) {
      $this->getVerboseLogger()->info($message, $context);
    }
  }

  /**
   * Gets the logger for verbose logging.
   *
   * @return \Psr\Log\LoggerInterface
   *   The logger.
   */
  abstract protected function getVerboseLogger(): LoggerInterface;

  /**
   * Gets the backend configuration for verbose logging.
   *
   * @return array<string, mixed>
   *   The backend configuration.
   */
  abstract protected function getVerboseLoggerConfig(): array;

}
