# Search API SQLite FTS5

[![Pipeline Status](https://git.drupalcode.org/project/search_api_sqlite/badges/main/pipeline.svg)](https://git.drupalcode.org/project/search_api_sqlite/-/pipelines)
[![Drupal](https://img.shields.io/badge/Drupal-11-blue.svg)](https://www.drupal.org/project/search_api_sqlite)
[![License](https://img.shields.io/badge/License-MIT-green.svg)](LICENSE)

A high-performance [Search API](https://www.drupal.org/project/search_api) backend for Drupal using SQLite's Full-Text Search (FTS5) extension.

## Table of Contents

- [Overview](#overview)
- [Features](#features)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Why SQLite FTS5?](#why-sqlite-fts5)
- [Comparison with Database Search](#comparison-with-database-search)
- [Search API Backends Comparison](#search-api-backends-comparison)
- [Development](#development)
- [License](#license)

## Overview

Search API SQLite provides a lightweight yet powerful search backend that leverages SQLite's built-in FTS5 full-text search engine. It offers significantly better search relevance and performance compared to the standard Database Search backend, without requiring external services like Solr or Elasticsearch.

This module is ideal for small to medium-sized Drupal sites that need quality search functionality without the complexity of managing additional infrastructure.

## Features

### Full-Text Search
- **BM25 Ranking** — Industry-standard relevance scoring algorithm
- **Phrase Matching** — Native support for exact phrase searches
- **Prefix Search** — Efficient wildcard searches for autocomplete
- **Unicode Support** — Full unicode-aware tokenization with diacritic normalization

### Search API Integration
- **Faceted Search** — Full support for the [Facets](https://www.drupal.org/project/facets) module including OR facets
- **Highlighting** — Native FTS5 highlighting of search terms in results
- **Autocomplete** — Support for [Search API Autocomplete](https://www.drupal.org/project/search_api_autocomplete)
- **All Field Types** — Text, string, integer, decimal, date, boolean, and URI fields

### Performance
- **Isolated Indexes** — Each search index uses its own SQLite database file
- **WAL Mode** — Concurrent reads without blocking
- **Auto-Optimization** — Configurable automatic index optimization after a threshold of changes
- **Memory-Mapped I/O** — Efficient large index handling
- **Optimized Facets** — Uses temp tables for efficient multi-facet queries on large result sets

### Tokenizer Options
- **Unicode61** — Standard unicode tokenizer with diacritics removal (default, recommended)
- **Porter** — Porter stemming for English word root matching (running → run)
- **ASCII** — Simple tokenizer for basic English text
- **Trigram** — Character-based matching for substring search, ideal for product codes and SKUs

### Matching Modes
- **Match All Words** — All search terms must appear in results (AND)
- **Prefix Matching** — Matches word beginnings, ideal for autocomplete
- **Phrase Matching** — Terms must appear consecutively in exact order

## Requirements

- Drupal 10.3+ or Drupal 11
- PHP 8.1+
- SQLite 3.35+ with FTS5 extension (included in most PHP installations)
- [Search API](https://www.drupal.org/project/search_api) module

## Installation

Install via Composer:

```bash
composer require drupal/search_api_sqlite
```

Enable the module:

```bash
drush en search_api_sqlite
```

## Configuration

1. Navigate to **Administration → Configuration → Search and metadata → Search API**
2. Add a new server or edit an existing one
3. Select **SQLite FTS5** as the backend
4. Configure the backend options:
   - **Tokenizer** — Choose between unicode61, porter, ascii, or trigram
   - **Case-sensitive matching** — For trigram tokenizer only
   - **Minimum word length** — Words shorter than this are ignored (not for trigram)
   - **Matching mode** — Match all words, prefix, or phrase matching
   - **Highlighting** — Enable/disable native FTS5 highlighting and configure markers
   - **Verbose logging** — Enable detailed logging for debugging
   - **Auto-optimization** — Enable automatic index optimization after a threshold of changes

### Database Storage

By default, index databases are stored in the private file system at `private://search_api_sqlite/`. Ensure your private file path is configured in `settings.php`:

```php
$settings['file_private_path'] = '/path/to/private/files';
```

## Why SQLite FTS5?

SQLite FTS5 provides enterprise-grade full-text search capabilities built directly into SQLite:

- **Zero Infrastructure** — No external services to install or maintain
- **Proven Technology** — Used by countless applications worldwide
- **BM25 Scoring** — The same ranking algorithm used by major search engines
- **Fast** — Optimized C implementation with efficient indexing
- **Reliable** — ACID-compliant with crash recovery

## Comparison with Database Search

| Feature | Database Search | SQLite FTS5 |
|---------|-----------------|-------------|
| Relevance Ranking | Basic frequency | BM25 (industry standard) |
| Phrase Search | Bigrams (high storage) | Native support |
| Prefix Search | Full table scan | Optimized index lookup |
| Highlighting | Not built-in | Native FTS5 support |
| Index Isolation | Shared database | Separate file per index |
| Concurrent Reads | Limited by connections | Unlimited (WAL mode) |

**Expected Performance Improvement: 2-3x faster across most operations**

## Search API Backends Comparison

| Backend | Infrastructure | Best For | Autocomplete | Facets | OR Facets | MLT | Spellcheck |
|---------|---------------|----------|--------------|--------|-----------|-----|------------|
| **SQLite FTS5** | None | Small/medium sites | ✓ | ✓ | ✓ | ✗ | ✗ |
| **Database Search** | None | Simple search | ✓ | ✓ | ✓ | ✗ | ✗ |
| **Solr** | Server | Large sites, NLP | ✓ | ✓ | ✓ | ✓ | ✓ |
| **Elasticsearch** | Server | Large sites, analytics | ✓ | ✓ | ✓ | ✓ | ✗ |
| **OpenSearch** | Server | AWS integration | ✗ | ✓ | ✓ | ✓ | ✗ |
| **Algolia** | SaaS | Instant search | ✓ | ✓ | ✓ | ✗ | ✗ |
| **Meilisearch** | Server | Typo-tolerant search | ✓ | ✓ | ✓ | ✗ | ✓ |

### Choose SQLite FTS5 When:
- Your site has less than 500K searchable items
- You want quality search without managing external services
- You need better relevance than Database Search provides
- Server resources are limited or shared hosting
- You want BM25 ranking, faceted search, and highlighting out of the box

### Consider Alternatives When:
- **Database Search**: You only need very basic search and already have it configured
- **Solr**: You need advanced NLP features (synonyms, spellcheck), "More Like This", or millions of documents
- **Elasticsearch/OpenSearch**: You need analytics, logging integration, or AWS-native search
- **Algolia**: You want a fully managed SaaS solution with instant search
- **Meilisearch**: You need typo-tolerant instant search with minimal configuration

## Development

### Running Tests

This module uses [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib) for local development and testing.

```bash
# Set up DDEV environment
ddev start
ddev poser  # Install dependencies

# Run code style checks
ddev phpcs

# Run static analysis
ddev phpstan

# Run all tests (unit + kernel)
ddev phpunit
```

### Code Quality Tools

- **PHPCS** — Drupal coding standards
- **PHPStan** — Static analysis (level 6)
- **PHPUnit** — Unit and kernel tests

## License

This project is licensed under the MIT license. See the [LICENSE](LICENSE) file for details.
