<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Search;

/**
 * Defines the interface for search result highlighting.
 */
interface HighlighterInterface {

  /**
   * Gets highlighted excerpts for search results.
   *
   * @param string $index_id
   *   The Search API index ID.
   * @param string $match_query
   *   The FTS5 MATCH query string.
   * @param array<string> $item_ids
   *   Item IDs to get excerpts for.
   * @param array<string> $columns
   *   FTS5 column names to get excerpts from.
   * @param array<string, mixed> $options
   *   Highlighting options:
   *   - prefix: Opening highlight tag.
   *   - suffix: Closing highlight tag.
   *   - excerpt_length: Maximum excerpt length in tokens.
   *
   * @return array<string, array<string, string>>
   *   Map of item_id => [column => highlighted_text].
   */
  public function getExcerpts(
    string $index_id,
    string $match_query,
    array $item_ids,
    array $columns,
    array $options = [],
  ): array;

}
