<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Utility;

/**
 * Helper class for formatting values.
 */
final class FormatHelper {

  /**
   * Formats bytes into a human-readable string.
   *
   * @param int $bytes
   *   The number of bytes.
   *
   * @return string
   *   Human-readable size string (e.g., "1.5 MB").
   */
  public static function formatBytes(int $bytes): string {
    if ($bytes === 0) {
      return '0 B';
    }

    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    $factor = (int) floor(log($bytes, 1024));
    $factor = min($factor, count($units) - 1);

    return sprintf('%.1f %s', $bytes / (1024 ** $factor), $units[$factor]);
  }

}
